local assets = {
	Asset("ANIM", "anim/staffs.zip"),
	Asset("ANIM", "anim/swap_staffs.zip")
}

local mycharacter

local function onFinished(inst)
	inst.SoundEmitter:PlaySound("dontstarve/common/gem_shatter")
	inst:Remove()
end

local function onEquip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_object", "swap_staffs", "orangestaff")
	owner.AnimState:Show("ARM_carry")
	owner.AnimState:Hide("ARM_normal")
end

local function onUnequip(inst, owner)
	owner.AnimState:Hide("ARM_carry")
	owner.AnimState:Show("ARM_normal")
end

local function onattack_bell(inst, attacker, target)
	--local x, y, z = target.Transform:GetWorldPosition()
	--local fx = SpawnPrefab("lightning")
	--fx.Transform:SetPosition(x, y, z)
	target.components.combat:GetAttacked(attacker, 20)
end

local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	--inst.entity:AddNetwork()

	MakeInventoryPhysics(inst)

	inst.AnimState:SetBank("staffs")
	inst.AnimState:SetBuild("staffs")
	inst.AnimState:PlayAnimation("orangestaff")

	inst:AddTag("nopunch")

	--inst.entity:SetPristine()
	--[[
	if not TheWorld.ismastersim then
		return inst
	end
	]]
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(40)
    inst.components.finiteuses:SetUses(40)
    inst.components.finiteuses:SetConsumption(ACTIONS.CASTSPELL, 1)
    inst.components.finiteuses:SetOnFinished(onFinished)

    inst:AddComponent("inspectable")
    
	inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(0)
    inst.components.weapon:SetRange(8, 10)
    inst.components.weapon:SetOnAttack(onattack_bell)
    inst.components.weapon:SetProjectile("lightning_projectile")

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem:ChangeImageName("orangestaff")
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onEquip)
    inst.components.equippable:SetOnUnequip(onUnequip)

    inst.fxcolour = {251/255, 233/255, 83/255}

    return inst
end



return Prefab("common/inventory/lightning_staff", fn, assets)
